//
//  UserProfileViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 12.02.23.
//

import JNGradientLabel
import UIKit

class UserProfileViewController : UIViewController {

    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    
    @IBOutlet var lighBankingIDLabel: UILabel!
    
    @IBOutlet var nameLabel: UILabel!
    
    @IBOutlet var addressHeaderLabel: UILabel!
    @IBOutlet var streetLabel: UILabel!
    @IBOutlet var cityLabel: UILabel!
    @IBOutlet var CountryLabel: UILabel!
    
    @IBOutlet var phoneNumerHeaderLabel: UILabel!
    @IBOutlet var phoneNumberDetailLabel: UILabel!
    
override func viewDidLoad() {
    super.viewDidLoad()
    
    UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                        .font : Fonts.mediumFontWithSize(size: 18)]
    
    self.navigationItem.backBarButtonItem?.tintColor = UIColor.white
    
    // top bar gradient color
    let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
    let gradientlocations: [CGFloat] = [1.0, 0.0]
    
    topBarLabel.textColor = .white
    topBarLabel.textGradientLocation = .background
    topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                            endPoint: CGPoint(x: 1.0, y: 1.0),
                                                            colors: gradientColors,
                                                            locations: gradientlocations)
    
    lighBankingIDLabel.font = Fonts.heavyFontWithSize(size: 17)
    
    nameLabel.font = Fonts.heavyFontWithSize(size: 17)
    
    addressHeaderLabel.font = Fonts.heavyFontWithSize(size: 17)
    
    streetLabel.font = Fonts.mediumFontWithSize(size: 16)
    streetLabel.textColor = Colors.greyColor
    cityLabel.font = Fonts.mediumFontWithSize(size: 16)
    cityLabel.textColor = Colors.greyColor
    CountryLabel.font = Fonts.mediumFontWithSize(size: 16)
    CountryLabel.textColor = Colors.greyColor
    
    phoneNumerHeaderLabel.font = Fonts.heavyFontWithSize(size: 17)
    phoneNumberDetailLabel.font = Fonts.mediumFontWithSize(size: 16)
    phoneNumberDetailLabel.textColor = Colors.greyColor
    
    
    
    
    lighBankingIDLabel.text = "LightBanking ID: " + appPINPublic
}


    @IBAction func backButton(_ sender: Any) {
    let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
    
    tabBarController.modalPresentationStyle = .fullScreen
    tabBarController.modalTransitionStyle = .crossDissolve
    

    present(tabBarController, animated: true)
    

    let indexData: [String: Int] = ["index" : 2]
    NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
}
}
